<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tolerance extends Model 
{

    protected $table = 'tolerances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function services()
    {
        return $this->belongsToMany('Service', 'service_tolerance', 'tolerance_id', 'service_id')->withTimestamps();
    }

}